/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.INBTType;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTypes;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ListNBT
extends CollectionNBT<INBT> {
    public static final INBTType<ListNBT> field_229694_a_ = new INBTType<ListNBT>(){

        @Override
        public ListNBT func_225649_b_(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
            nBTSizeTracker.func_152450_a(296L);
            if (n > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            byte by = dataInput.readByte();
            int \u26032 = dataInput.readInt();
            if (by == 0 && \u26032 > 0) {
                throw new RuntimeException("Missing type on ListTag");
            }
            nBTSizeTracker.func_152450_a(32L * (long)\u26032);
            INBTType<?> \u26033 = NBTTypes.func_229710_a_(by);
            ArrayList \u26034 = Lists.newArrayListWithCapacity((int)\u26032);
            for (int i = 0; i < \u26032; ++i) {
                \u26034.add(\u26033.func_225649_b_(dataInput, n + 1, nBTSizeTracker));
            }
            return new ListNBT(\u26034, by);
        }

        @Override
        public String func_225648_a_() {
            return "LIST";
        }

        @Override
        public String func_225650_b_() {
            return "TAG_List";
        }

        @Override
        public /* synthetic */ INBT func_225649_b_(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
            return this.func_225649_b_(dataInput, n, nBTSizeTracker);
        }
    };
    private static final ByteSet field_229695_b_ = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private final List<INBT> field_74747_a;
    private byte field_74746_b;

    private ListNBT(List<INBT> list, byte by) {
        this.field_74747_a = list;
        this.field_74746_b = by;
    }

    public ListNBT() {
        this(Lists.newArrayList(), 0);
    }

    @Override
    public void func_74734_a(DataOutput dataOutput) throws IOException {
        this.field_74746_b = this.field_74747_a.isEmpty() ? (byte)0 : this.field_74747_a.get(0).func_74732_a();
        dataOutput.writeByte(this.field_74746_b);
        dataOutput.writeInt(this.field_74747_a.size());
        for (INBT iNBT : this.field_74747_a) {
            iNBT.func_74734_a(dataOutput);
        }
    }

    @Override
    public byte func_74732_a() {
        return 9;
    }

    public INBTType<ListNBT> func_225647_b_() {
        return field_229694_a_;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < this.field_74747_a.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.field_74747_a.get(i));
        }
        return stringBuilder.append(']').toString();
    }

    private void func_218663_f() {
        if (this.field_74747_a.isEmpty()) {
            this.field_74746_b = 0;
        }
    }

    @Override
    public INBT remove(int n) {
        INBT iNBT = this.field_74747_a.remove(n);
        this.func_218663_f();
        return iNBT;
    }

    @Override
    public boolean isEmpty() {
        return this.field_74747_a.isEmpty();
    }

    public CompoundNBT func_150305_b(int n) {
        if (n >= 0 && n < this.field_74747_a.size() && (\u2603 = this.field_74747_a.get(n)).func_74732_a() == 10) {
            return (CompoundNBT)\u2603;
        }
        return new CompoundNBT();
    }

    public ListNBT func_202169_e(int n) {
        if (n >= 0 && n < this.field_74747_a.size() && (\u2603 = this.field_74747_a.get(n)).func_74732_a() == 9) {
            return (ListNBT)\u2603;
        }
        return new ListNBT();
    }

    public short func_202170_f(int n) {
        if (n >= 0 && n < this.field_74747_a.size() && (\u2603 = this.field_74747_a.get(n)).func_74732_a() == 2) {
            return ((ShortNBT)\u2603).func_150289_e();
        }
        return 0;
    }

    public int func_186858_c(int n) {
        if (n >= 0 && n < this.field_74747_a.size() && (\u2603 = this.field_74747_a.get(n)).func_74732_a() == 3) {
            return ((IntNBT)\u2603).func_150287_d();
        }
        return 0;
    }

    public int[] func_150306_c(int n) {
        if (n >= 0 && n < this.field_74747_a.size() && (\u2603 = this.field_74747_a.get(n)).func_74732_a() == 11) {
            return ((IntArrayNBT)\u2603).func_150302_c();
        }
        return new int[0];
    }

    public double func_150309_d(int n) {
        if (n >= 0 && n < this.field_74747_a.size() && (\u2603 = this.field_74747_a.get(n)).func_74732_a() == 6) {
            return ((DoubleNBT)\u2603).func_150286_g();
        }
        return 0.0;
    }

    public float func_150308_e(int n) {
        if (n >= 0 && n < this.field_74747_a.size() && (\u2603 = this.field_74747_a.get(n)).func_74732_a() == 5) {
            return ((FloatNBT)\u2603).func_150288_h();
        }
        return 0.0f;
    }

    public String func_150307_f(int n) {
        if (n < 0 || n >= this.field_74747_a.size()) {
            return "";
        }
        INBT iNBT = this.field_74747_a.get(n);
        if (iNBT.func_74732_a() == 8) {
            return iNBT.func_150285_a_();
        }
        return iNBT.toString();
    }

    @Override
    public int size() {
        return this.field_74747_a.size();
    }

    @Override
    public INBT get(int n) {
        return this.field_74747_a.get(n);
    }

    @Override
    public INBT set(int n, INBT iNBT) {
        \u2603 = this.get(n);
        if (!this.func_218659_a(n, iNBT)) {
            throw new UnsupportedOperationException(String.format("Trying to add tag of type %d to list of %d", iNBT.func_74732_a(), this.field_74746_b));
        }
        return \u2603;
    }

    @Override
    public void add(int n, INBT iNBT) {
        if (!this.func_218660_b(n, iNBT)) {
            throw new UnsupportedOperationException(String.format("Trying to add tag of type %d to list of %d", iNBT.func_74732_a(), this.field_74746_b));
        }
    }

    @Override
    public boolean func_218659_a(int n, INBT iNBT) {
        if (this.func_218661_a(iNBT)) {
            this.field_74747_a.set(n, iNBT);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_218660_b(int n, INBT iNBT) {
        if (this.func_218661_a(iNBT)) {
            this.field_74747_a.add(n, iNBT);
            return true;
        }
        return false;
    }

    private boolean func_218661_a(INBT iNBT) {
        if (iNBT.func_74732_a() == 0) {
            return false;
        }
        if (this.field_74746_b == 0) {
            this.field_74746_b = iNBT.func_74732_a();
            return true;
        }
        return this.field_74746_b == iNBT.func_74732_a();
    }

    @Override
    public ListNBT func_74737_b() {
        List<INBT> list = NBTTypes.func_229710_a_(this.field_74746_b).func_225651_c_() ? this.field_74747_a : Iterables.transform(this.field_74747_a, INBT::func_74737_b);
        ArrayList \u26032 = Lists.newArrayList(list);
        return new ListNBT(\u26032, this.field_74746_b);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ListNBT && Objects.equals(this.field_74747_a, ((ListNBT)object).field_74747_a);
    }

    @Override
    public int hashCode() {
        return this.field_74747_a.hashCode();
    }

    @Override
    public ITextComponent func_199850_a(String string2, int n) {
        String string2;
        if (this.isEmpty()) {
            return new StringTextComponent("[]");
        }
        if (field_229695_b_.contains(this.field_74746_b) && this.size() <= 8) {
            String string3 = ", ";
            StringTextComponent \u26032 = new StringTextComponent("[");
            for (int i = 0; i < this.field_74747_a.size(); ++i) {
                if (i != 0) {
                    \u26032.func_240702_b_(", ");
                }
                \u26032.func_230529_a_(this.field_74747_a.get(i).func_197637_c());
            }
            \u26032.func_240702_b_("]");
            return \u26032;
        }
        StringTextComponent stringTextComponent = new StringTextComponent("[");
        if (!string2.isEmpty()) {
            stringTextComponent.func_240702_b_("\n");
        }
        String \u26033 = String.valueOf(',');
        for (int i = 0; i < this.field_74747_a.size(); ++i) {
            StringTextComponent stringTextComponent2 = new StringTextComponent(Strings.repeat((String)string2, (int)(n + 1)));
            stringTextComponent2.func_230529_a_(this.field_74747_a.get(i).func_199850_a(string2, n + 1));
            if (i != this.field_74747_a.size() - 1) {
                stringTextComponent2.func_240702_b_(\u26033).func_240702_b_(string2.isEmpty() ? " " : "\n");
            }
            stringTextComponent.func_230529_a_(stringTextComponent2);
        }
        if (!string2.isEmpty()) {
            stringTextComponent.func_240702_b_("\n").func_240702_b_(Strings.repeat((String)string2, (int)n));
        }
        stringTextComponent.func_240702_b_("]");
        return stringTextComponent;
    }

    @Override
    public byte func_230528_d__() {
        return this.field_74746_b;
    }

    @Override
    public void clear() {
        this.field_74747_a.clear();
        this.field_74746_b = 0;
    }

    @Override
    public /* synthetic */ INBT func_74737_b() {
        return this.func_74737_b();
    }

    @Override
    public /* synthetic */ Object remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ void add(int n, Object object) {
        this.add(n, (INBT)object);
    }

    @Override
    public /* synthetic */ Object set(int n, Object object) {
        return this.set(n, (INBT)object);
    }

    @Override
    public /* synthetic */ Object get(int n) {
        return this.get(n);
    }
}

